/*-*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
    mycolor plugin for Chatzilla.  Prepends mIRC control codes to your text.
    Copyright (C) 2004  John J Foerch

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

const LF = "\n";


function initPlugin () {
    plugin.id = 'mycolor';
    plugin.major = 0;
    plugin.minor = 12;
    plugin.version = plugin.major +'.'+ plugin.minor;
    plugin.description = 'Prepends mIRC control codes to your text.';

	if (! ('outputFilters' in client)) { client.outputFilters = new Object(); }
	if (! ('mycolor' in client.outputFilters)) {
		client.outputFilters['mycolor'] = new Object();
	}
	client.outputFilters['mycolor'].enabled = true;
	client.outputFilters['mycolor'].func = applycolor;

	//preferences
	plugin.prefAry = [
		['mycolor.code', ''],
        ];
	client.prefManager.addPrefs(plugin.prefAry);

    //commands
    plugin.cmdlist = [
        ['mycolor',cmdMyColor,null,'[<arg> [<...>]]'],
        ];
    client.commandManager.defineCommands(plugin.cmdlist);

    //help
    client.commandManager.commands.mycolor.help = mycolorhelp();
}


function enablePlugin () {
    //this function is called by Chatzilla when the
    //command "/enable-plugin plugin-name" is issued.
    display ('mycolor plugin enabled');
    plugin.enabled = true;
}


function disablePlugin () {
    //this function is called by Chatzilla when the
    //command "/disable-plugin plugin-name" is issued.
    display ('mycolor plugin disabled');
    plugin.enabled = false;
}


function applycolor (msg, msgtype) {
    if (plugin.enabled && client.prefs['mycolor.code'] != '') {
        msg = replaceColorCodes(client.prefs['mycolor.code']) + msg;
    }
    return msg;
}


function cmdMyColor (e) {
    if (e.arg === null) {
        displayMyColor();
        return;
    }
    if (e.arg == '-') {
        try {
            client.prefManager.clearPref('mycolor.code');
        } catch (e) {
            display ('failed to reset preference mycolor.code');
            return;
        }
        display ('reset mycolor.code to default');
        return;
    }
    //
    //TODO: check if only one arg was provided, and contains multiple % characters.
    //TODO: if so, treat it as a raw code string.
    //
    //otherwise iterate through e.argList and make color code
    var fg_f=true;
    var fg=null;
    var bg=null;
    var bold=null;
    var underline=null;
    var reverse=null;
    for (var i in e.argList) {
        var j = e.argList[i].toLowerCase();
        if (! isNaN(parseInt(j,10))) { 
            j = j % 16;
            if (fg_f) { fg = j; fg_f = false; }
            else { bg = j; }
        }
        else if (j == 'bold' || j == 'b' || j == '%b') { bold = true; }
        else if (j == 'underline' || j == 'u' || j == '%u') { underline = true; }
        else if (j == 'reverse' || j == 'r' || j == '%r') { reverse = true; }
    }
    //set the pref
    var code=
        (bold === true ? '%B' : '') +
        (underline === true ? '%U' : '') +
        (reverse === true ? '%R' : '') +
        (fg !== null ? '%C'+ (String(fg).length == 1 ? '0' : '') +fg : '') +
        (bg !== null ? ','+ (String(bg).length == 1 ? '0' : '') +bg : '');

    client.prefManager.setPref('mycolor.code', code);//can I make this not display an info line?
    displayMyColor();


    function displayMyColor() {
        var r = '';
        var code = client.prefs['mycolor.code'];
        if (code.indexOf ('%B') != -1) { r += 'bold '; }
        if (code.indexOf ('%U') != -1) { r += 'underline '; }
        if (code.indexOf ('%R') != -1) { r += 'reverse '; }
        var coloridx = code.indexOf ('%C');
        if (coloridx != -1) {
            var fg_idx = coloridx + 2;
            r += 'color: '+ code.substr(fg_idx,2);
            if (code.indexOf(',') != -1) {
                var bg_idx = fg_idx + 3;
                r += ','+ code.substr(bg_idx,2);
            }
        }
        if (r == '') { display ('No codes are in use.'); }
        else { display ('Codes in use are: ' + r); }
    }
}






function mycolorhelp () {
    return 'invoke |/mycolor| with no arguments to see your current color setting.'+LF+
        'do |/mycolor -| to clear your color setting.'+LF+
        'invoke it with a series of keywords to set the color.'+LF+
        'keywords can be mIRC color numbers or style names including underline, bold, and reverse.'+LF+
        'The first color number is treated as foreground, and the second, if present, as background.';
}



function localeString () {
    Components.classes["@mozilla.org/chrome/chrome-registry;1"].getService(Components.interfaces.nsIXULChromeRegistry).getSelectedLocale("global");

}

