/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Nvu.
 *
 * The Initial Developer of the Original Code is
 * Lindows.com.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Daniel Glazman (glazman@disruptive-innovations.com), on behalf of Lindows.com
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

function Startup()
{
  gDialog.okButton        = document.documentElement.getButton("accept");
  gDialog.okButton.setAttribute("label", _GetString("CleanUp") );

  gDialog.nestedListsCheckbox = document.getElementById("nestedListsCheckbox");
  gDialog.trailinBRCheckbox   = document.getElementById("trailinBRCheckbox");
  gDialog.emptyBlocksCheckbox = document.getElementById("emptyBlocksCheckbox");
  gDialog.emptyCellsCheckbox  = document.getElementById("emptyCellsCheckbox");

  gDialog.nestedListsReport   = document.getElementById("nestedListsReport");
  gDialog.trailinBRReport     = document.getElementById("trailinBRReport");
  gDialog.emptyBlocksReport   = document.getElementById("emptyBlocksReport");
  gDialog.emptyCellsReport    = document.getElementById("emptyCellsReport");
}

function OnlyWhiteTextNodesStartingAtNode(node, acceptOneBR)
{
  var result = true;
  var brOccurences = 0;
  while (node && result)
  {
    if (node.nodeType != Node.TEXT_NODE)
    {
      if (acceptOneBR &&
          node.nodeType == Node.ELEMENT_NODE &&
          node.nodeName.toLowerCase() == "br")
      {
        brOccurences++;
         if (brOccurences > 1)
           result = false;
      }
      else
        result = false;
    }
    else
      result = RegExp( /^\s*$/ ).test(node.data);
    node = node.nextSibling;
  }
  return result;
}

function RunCleanup()
{
  ClearReport(gDialog.nestedListsReport, gDialog.nestedListsCheckbox);
  ClearReport(gDialog.trailinBRReport,   gDialog.trailinBRCheckbox);
  ClearReport(gDialog.emptyBlocksReport, gDialog.emptyBlocksCheckbox);
  ClearReport(gDialog.emptyCellsReport,  gDialog.emptyCellsCheckbox);

  function acceptNode(node, nestedLists, trailingBR, emptyBLocks, emptyCells)
  {
    // TBD : useless test below
    if (node.nodeType == Node.ELEMENT_NODE)
    {
      var tagName = node.nodeName.toLowerCase();
      switch (tagName)
      {
        case "br":
          if (gDialog.trailinBRCheckbox.checked &&
              OnlyWhiteTextNodesStartingAtNode(node.nextSibling, false))
            return NodeFilter.FILTER_ACCEPT;
          break;

        case "ul":
        case "ol":
          if (gDialog.nestedListsCheckbox.checked)
          {
            var parentTagName = node.parentNode.nodeName.toLowerCase();
            if (parentTagName == "ul" || parentTagName == "ol")
              return NodeFilter.FILTER_ACCEPT;
          }
          break;

        case "p":
        case "div":
        case "h1":
        case "h2":
        case "h3":
        case "h4":
        case "h5":
        case "h6":
          if (gDialog.emptyBlocksCheckbox.checked &&
              OnlyWhiteTextNodesStartingAtNode(node.firstChild, true))
            return NodeFilter.FILTER_ACCEPT;
          break;

        case "td":
        case "th":
          if (gDialog.emptyCellsCheckbox.checked &&
              OnlyWhiteTextNodesStartingAtNode(node.firstChild, true))
            return NodeFilter.FILTER_ACCEPT;
          break;
          
      }
    }
    return NodeFilter.FILTER_SKIP;
  }

  var theDocument = GetCurrentEditor().document;
  var treeWalker = theDocument.createTreeWalker(theDocument.documentElement,
                                                NodeFilter.SHOW_ELEMENT,
                                                acceptNode,
                                                true);
  if (treeWalker) {
    var theNode = treeWalker.nextNode(), tmpNode;
    var editor = GetCurrentEditor();
    editor.beginTransaction();

    while (theNode) {
      var tagName = theNode.nodeName.toLowerCase();
      if (tagName == "ul" || tagName == "ol")
      {
        var liNode = theNode.previousSibling;
        while (liNode && liNode.nodeName.toLowerCase() != "li")
          liNode = liNode.previousSibling;

        tmpNode = treeWalker.nextNode();
        if (liNode)
        {
          editor.deleteNode(theNode);
          editor.insertNodeAfter(theNode, liNode, null);
          IncreaseReport(gDialog.nestedListsReport);
        }
        theNode = tmpNode;
      }

      else if (tagName == "br")
      {
        tmpNode = treeWalker.nextNode();
        var parentTagName = theNode.parentNode.nodeName.toLowerCase();
        if (parentTagName != "td" && parentTagName != "th")
        {
          editor.deleteNode(theNode)
          IncreaseReport(gDialog.trailinBRReport);
        }

        theNode = tmpNode;
      }
      
      else if (tagName == "td" || tagName == "th")
      {
        if (theNode.hasAttribute("align") ||
            theNode.hasAttribute("valign"))
        {
          editor.removeAttribute(theNode, "align");
          editor.removeAttribute(theNode, "valign");
          IncreaseReport(gDialog.emptyCellsReport);

        }
        theNode = treeWalker.nextNode();
      }

      else
      {
        tmpNode = treeWalker.nextNode();
        editor.deleteNode(theNode)
        IncreaseReport(gDialog.emptyBlocksReport);

        theNode = tmpNode;
      }
    }

    editor.endTransaction();
  
  }
  return false;
}

function IncreaseReport(report)
{
  var reportValue = Number(report.value) + 1;
  report.value = reportValue;
}

function ClearReport(report, checkbox)
{
  if (report)
    if (checkbox && checkbox.checked)
      report.setAttribute("value", "0");
    else
      report.setAttribute("value", " ");
}

function _GetString(name)
{
if (!gStringBundle)
{
try {
strBundleService =
Components.classes["@mozilla.org/intl/stringbundle;1"].getService();
strBundleService =
strBundleService.QueryInterface(Components.interfaces.nsIStringBundleService);

gStringBundle = strBundleService.createBundle("chrome://editor/locale/MarkupCleaner.properties");

} catch (ex) {}
}
if (gStringBundle)
{
try {
return gStringBundle.GetStringFromName(name);
} catch (e) {}
}
return null;
}
